<x-app-layout>
    <x-slot name="header">
        Cities of {{ $state->name }}
    </x-slot>

    <div class="row row-sm">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <a href="{{ route('admin.location.city.create', $state->id) }}" class="btn btn-primary">Add New</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered text-nowrap border-bottom">
                            <thead>
                                <tr>
                                    <th class="border-bottom-0">Name</th>
                                    <th class="border-bottom-0">Code</th>
                                    <th class="border-bottom-0">Status</th>
                                    <th class="border-bottom-0">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($cities as $city)
                                <tr>
                                    <td>{{ $city->name }}</td>
                                    <td>{{ $city->code }}</td>
                                    <td>
                                        @if ($city->status == 1)
                                        <span class="badge bg-success">Active</span>
                                        @else
                                        <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.location.city.edit', [$state->id, $city->id]) }}"
                                            class="btn btn-primary btn-sm">Edit</a>
                                        <a href="javascript:void(0)" data-url="{{ route('admin.location.city.destroy', [$state->id, $city->id]) }}" class="btn btn-danger confirm-me btn-sm">Delete</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-slot name="script">
        <x-datatable-js />
        <x-confirm-js />
    </x-slot>
</x-app-layout>
